;;; - ------------------------------------------------------------------------------- - ;
;;; -                T O O L - A C M - C M D L A Y E R                                - ;
;;; - ------------------------------------------------------------------------------- - ;
;;; - Beschreibung : Befehlsabhngige Layerzuordnung                                  - ;
;;; - Befehle      : ACM-CMDLAYER                                                     - ;
;;; - ------------------------------------------------------------------------------- - ;
;;; - letzte nderung am : 15.02.2025                                                 - ;
;;; -              durch : Thomas Krger                                              - ;
;;; - ------------------------------------------------------------------------------- - ;
(vl-load-com)
;;; - ------------------------------------------------------------------------------ - ;
(defun CMDLAYER:STDLAYLIST()
  '( ("TEXT"        "TEXTLAYER")
     ("MTEXT"       "TEXTLAYER")
     ("ATTDEF"      "TEXTLAYER")
     ("FIELD"       "TEXTLAYER")
     ("ARC"            "KONTUR")
     ("CIRCLE"         "KONTUR")
     ("RAY"            "KONTUR")
     ("LINE"           "KONTUR")
     ("PLINE"          "KONTUR")
     ("POLYGON"        "KONTUR")
     ("3DPOLY"         "KONTUR")
     ("ELLIPSE"        "KONTUR")
     ("XLINE"           "XLINE")
     ("RAY"             "XLINE")
     ("HATCH"           "HATCH")
     ("BHATCH"          "HATCH")
     ("DIM"         "DIMENSION")
     ("DIM1"        "DIMENSION")
     ("DIMALIGNED"  "DIMENSION")
     ("DIMBASELINE" "DIMENSION")
     ("DIMARC"      "DIMENSION")
     ("DIMDIAMETER" "DIMENSION")
     ("DIMLINEAR"   "DIMENSION")
     ("DIMCENTER"   "DIMENSION")
     ("DIMORDINATE" "DIMENSION")
     ("DIMRADIUS"   "DIMENSION")
   )
)  
;;; - ------------------------------------------------------------------------------ - ;
(defun CMDLAYER:INIT(CMDLAYERINI /  FILE ZEILE LISTE)
  (if(and(=(type CMDLAYERINI)'STR)
         (setq CMDLAYERINI(findfile CMDLAYERINI))
         (setq FILE(open CMDLAYERINI "r"))
     )
    (progn
      (while (setq ZEILE(read-line FILE))(setq LISTE(cons ZEILE LISTE)))
      (close FILE)
      (if(setq LISTE
           (vl-remove-if 'null
             (mapcar
               '(lambda(X / Y A B)
                  (if(and(/=(substr X 1 1)";")(setq Y (vl-string-search "=" X))
                         (snvalid (setq A(vl-string-trim " \t" (substr X 1     Y))))
                         (snvalid (setq B(vl-string-trim " \t" (substr X (+ Y 2)))))
                     )
                    (list A B)
                  )  
                )  
               (reverse LISTE)
             )
           )  
         )
        (progn
          (vl-bb-set 'BB-CMDLAYER-LAYLIST LISTE)
          LISTE
        )  
      )  
    )  
  )  
)
;;; - ------------------------------------------------------------------------------ - ;
(defun C:CMDLAYER:SETUP(/ SUPDIR CMDLAYERINI FILE DT:RUNAPPandWAIT)
  (defun DT:RUNAPPandWAIT(COMMANDS VISIBLE / WScript)
    (if(setq WScript (vlax-get-or-create-object "WScript.Shell"))
      (if VISIBLE
        (vl-catch-all-apply 'vlax-invoke-method (list WScript "Run" COMMANDS 1 :vlax-true))
        (vl-catch-all-apply 'vlax-invoke-method (list WScript "Run" COMMANDS 6 :vlax-true))
      )
    )
    (princ)
  )
  (if(and(setq SUPDIR(cond((findfile"ACAD.lin"))
                          ((findfile"ACADiso.lin"))
                          ((getvar"DWGPREFIX"))
                     )
         )
         (setq SUPDIR(car(fnsplitl SUPDIR)))
         (setq CMDLAYERINI(strcat SUPDIR "CMDLAYER.INI"))
         (setq CMDLAYERINI
           (cond     
             ((and(findfile CMDLAYERINI)(setq FILE(open CMDLAYERINI "a")))
               (close FILE)
               (findfile CMDLAYERINI)
             ) 
             ((setq FILE(open CMDLAYERINI "w"))
               (princ ";;;[CMDLAYER]   LAYERLISTE" FILE)
               (mapcar
                 '(lambda(X)(princ(strcat "\n"(substr (strcat (car X) "                    ") 1 20)
                                          "= "
                                          (cadr X)
                                  )
                                  FILE
                            )
                  )
                  (append '((";;; COMMAND"   "LAYER"))
                           (CMDLAYER:STDLAYLIST) 
                  )
               )  
               (close FILE)
               (findfile CMDLAYERINI)
             )
           )
         )
     )
    (progn
      (princ"\n...starte Notepad...weiter nach schlieen von Notepad...\n")
      (DT:RUNAPPandWAIT (strcat "Notepad.exe \"" CMDLAYERINI "\"") t)
      (if(CMDLAYER:INIT CMDLAYERINI)(princ"\nCMDLAYER initialisiert.\n"))
    )
  )  
)  
;;; - ------------------------------------------------------------------------------ - ;
(defun CMDLAYER:BEFOR(REACTOR ARGUMENTS / CMDNAME LASTOBJ)
  (defun SETORCREATELAYER(NAME)
    (and(=(type NAME)'STR)
        (or(tblobjname "LAYER" NAME)
           (not(vl-catch-all-error-p
                 (vl-catch-all-apply
                   'vla-add
                   (list (vla-get-layers(vla-get-activedocument(vlax-get-acad-object)))
                         NAME
                   )
                 )
               )
           )
         )  
         (not(vl-catch-all-error-p(vl-catch-all-apply 'setvar (list "CLAYER" NAME))))
    )                  
  )  
  (if(and(=(type(setq CMDNAME(car ARGUMENTS)))'STR)
         (if(=(vl-bb-ref '*BB-CMDLAYERINFO*)1)
           (princ (strcat "\n[CMDLAYER:INFO] Befehl war: " CMDNAME))
           'T
         )   
         (or(=(type(setq LAYLIST(vl-bb-ref 'BB-CMDLAYER-LAYLIST)))'LIST)
            (setq LAYLIST (CMDLAYER:STDLAYLIST))                
         )  
         (if(setq LAYER(cadr(assoc(strcase CMDNAME)LAYLIST)))
           (if(=(vl-bb-ref '*BB-CMDLAYERINFO*)1)
              (princ (strcat " ---> zugeordneter Layer: \"" LAYER"\"\n"))
              'T
           )
           (if(=(vl-bb-ref '*BB-CMDLAYERINFO*)1)
              (not(princ  " ---> zugeordneter Layer: keiner\n"))
           )     
         )       
         (setq *CMDLAYER-OLDLAYER* (getvar "CLAYER"))
         (SETORCREATELAYER LAYER)
     )
    (progn
      (setq *CMDLAYER-ACTIVE* 'T)
    )  
  )
)
;;; - ------------------------------------------------------------------------------ - ;
(defun CMDLAYER:AFTER(REACTOR ARGUMENTS / CMDNAME AWS INSERT)
  (if (and *CMDLAYER-ACTIVE* (tblobjname "LAYER" *CMDLAYER-OLDLAYER*))      
    (progn      
      (setq *CMDLAYER-ACTIVE* nil)
      (not(vl-catch-all-error-p
            (vl-catch-all-apply 'setvar (list "CLAYER" *CMDLAYER-OLDLAYER*))            
          )  
      )    
    )      
  )          
) 
;;; - ------------------------------------------------------------------------------ - ;
(defun C:CMDLAYER:REMOVE(/ RLIST)
  (if(and(setq RLIST(cdr(car(vlr-reactors :vlr-command-Reactor))))
         (setq RLIST(vl-remove-if
                      'null
                      (mapcar
                        '(lambda(X / RDATA)
                           (if(and(not(vl-catch-all-error-p
                                       (setq RDATA(vl-catch-all-apply
                                                    'vlr-data (list X)
                                                  )
                                       )
                                      )
                                  )
                                  (= RDATA "CMDLAYER")
                              )
                             X
                           )  
                         )  
                         RLIST
                      )
                    )  
         )
     )    
    (foreach X RLIST
       (not(vl-catch-all-error-p(vl-catch-all-apply'vlr-remove (list X))))
    )
  )
  (princ)
)
;;; - ------------------------------------------------------------------------------ - ;
(defun C:CMDLAYER:INFO-ON()  (vl-bb-set '*BB-CMDLAYERINFO* 1)(princ))
(defun C:CMDLAYER:INFO-OFF() (vl-bb-set '*BB-CMDLAYERINFO* 0)(princ)) 
;;; - ------------------------------------------------------------------------------ - ;
(defun C:CMDLAYER:INSTALL(/ RLIST SUPDIR CMDLAYERINI)
  (if(and(setq SUPDIR(cond((findfile"ACAD.lin"))
                          ((findfile"ACADiso.lin"))
                          ((getvar"DWGPREFIX"))
                     )
         )
         (setq SUPDIR(car(fnsplitl SUPDIR)))
         (setq CMDLAYERINI(strcat SUPDIR "CMDLAYER.INI"))
         (or(CMDLAYER:INIT CMDLAYERINI)
            (C:CMDLAYER:SETUP)
         )
     )
    (progn
      (C:CMDLAYER:REMOVE)
      (C:CMDLAYER:INFO-OFF)
      (setq *INSERTFITATTS*(vlr-command-reactor
                             "CMDLAYER"
                             '((:vlr-commandWillStart . CMDLAYER:BEFOR)
                               (:vlr-commandEnded     . CMDLAYER:AFTER)
                               (:vlr-commandCancelled . CMDLAYER:AFTER)
                               (:vlr-commandFailed    . CMDLAYER:AFTER)
                              )
                           )
      )
      (prompt"\nCMDLAYER installiert... ")
    )
  )  
  (princ)
)
;;; - ------------------------------------------------------------------------------- - ;
(defun ACM-CMDLAYER:INFO() 
  (mapcar
    'princ
    (list
      "\n\n"
      "\nACM-CMDLAYER : Automatische befehlsabhngige Layerverwaltung" 
      "\n============== "
      "\n(C) Thomas Krger 2025" 
      "\nE-Mail: tk@cad-od.de"
      "\nBefehlszeilenaufrufe :  CMDLAYER:INSTALL / CMDLAYER:SETUP / CMDLAYER:REMOVE\n"
    )
  )
  (princ)  
)
;;; - ------------------------------------------------------------------------------- - ;
(ACM-CMDLAYER:INFO)
(princ)
